﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Inet.Viewer.Data;
namespace Inet.Viewer.WinForms.Prompt
{
    /// <summary>
    /// Range prompt panel with a from and to field
    /// </summary>
    public partial class RangePromptField : PromptControl
    {
        /// <summary>
        /// Panel for the given prompt
        /// </summary>
        /// <param name="prompt">prompt to display panel for</param>
        public RangePromptField(PromptData prompt)
        {
            this.PromptData = prompt;
            InitializeComponent();
            txtValueBoxFrom.TextChanged += HandleChanged;
            txtValueBoxTo.TextChanged += HandleChanged;
            PromptValue selectedValue = prompt.Values;
            if (selectedValue is RangePromptValue)
            {
                this.txtValueBoxFrom.Text = ((RangePromptValue)selectedValue).StartValue.ValueString;
                this.txtValueBoxTo.Text = ((RangePromptValue)selectedValue).EndValue.ValueString;
                this.chkIncludeFrom.Checked = ((RangePromptValue)selectedValue).IncludeLow;
                this.chkIncludeTo.Checked = ((RangePromptValue)selectedValue).IncludeHigh;
            }
            else
            {
                this.chkIncludeFrom.Checked = true;
                this.chkIncludeTo.Checked = true;
            }
            this.AutoValidate = AutoValidate.Disable;
            ErrorProvider = errorProvider;
        }

        /// <summary>
        /// <inheritDoc/>
        /// </summary>
        internal override PromptValue Value
        {
            get
            {
                SinglePromptValue start = new SinglePromptValue(PromptData.Type, this.txtValueBoxFrom.Text);
                SinglePromptValue end = new SinglePromptValue(PromptData.Type, this.txtValueBoxTo.Text);
                RangePromptValue v = new RangePromptValue(start, end, chkIncludeFrom.Checked, chkIncludeTo.Checked, PromptData.Type);
                return v;
            }
        }

        /// <inheritdoc/>
        internal override bool ValidatePrompt()
        {
            errorProvider.Clear();
            RangePromptValue value = null;
            try
            {
                value = (RangePromptValue)Value;
                bool valFrom = ValidatePrompt(value.StartValue, chkIncludeFrom);
                bool valTo =  ValidatePrompt(value.EndValue, chkIncludeTo);
                return valFrom && valTo && ValidatePrompt(value, chkIncludeTo);
            } 
            catch (Exception exc)
            {
                ErrorMessage = exc.Message;
                if (ShowError)
                {
                    errorProvider.SetError(chkIncludeTo, ErrorMessage);
                }
                return false;
            }
        }
    }
}
